/*
 * Decompiled with CFR 0.152.
 */
package betterdays.time.effects;

import betterdays.config.ConfigHandler;
import betterdays.time.TimeContext;
import betterdays.time.effects.AbstractTimeEffect;
import betterdays.time.effects.EffectCondition;
import betterdays.wrappers.ServerLevelWrapper;
import com.google.common.primitives.Ints;

public class WeatherSleepEffect
extends AbstractTimeEffect {
    @Override
    public void onTimeTick(TimeContext context) {
        ServerLevelWrapper level = context.getLevel();
        EffectCondition condition = ConfigHandler.Common.weatherEffect();
        boolean allAwake = context.getTimeService().sleepStatus.allAwake();
        if (level.weatherCycleEnabled() && (condition == EffectCondition.ALWAYS || condition == EffectCondition.SLEEPING && !allAwake)) {
            this.progressWeather(context);
        }
    }

    private void progressWeather(TimeContext context) {
        ServerLevelWrapper level = context.getLevel();
        int clearWeatherTime = level.levelData.m_6537_();
        int thunderTime = level.levelData.m_6558_();
        int rainTime = level.levelData.m_6531_();
        int weatherSpeed = Ints.saturatedCast((long)(context.getTimeDelta().longValue() - 1L));
        if (clearWeatherTime <= 0) {
            if (thunderTime > 0) {
                thunderTime = Math.max(1, thunderTime - weatherSpeed);
                level.levelData.m_6398_(thunderTime);
            }
            if (rainTime > 0) {
                rainTime = Math.max(1, rainTime - weatherSpeed);
                level.levelData.m_6399_(rainTime);
            }
        }
    }
}

